package gov.va.med.mhv.common.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "FACILITY_INFO")
public class FacilityInfo extends AbstractBaseEntity {

	private static final long serialVersionUID = -6434460912975346237L;

	@Id
	@Column(name = "FACILITY_INFO_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;

	@Column(name = "DOMAIN_NAME")
	private String domainName;

	@Column(name = "IP_ADDRESS")
	private String ipAddess;

	@Column(name = "TIMEOUT")
	private Long timeout;

	@Column(name = "TREATMENT")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean treatment;

	@Column(name = "STATION_NUMBER")
	private String stationNumber;

	@Column(name = "NAME")
	private String name;

	@Column(name = "PORT")
	private Integer port;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public String getIpAddess() {
		return ipAddess;
	}

	public void setIpAddess(String ipAddess) {
		this.ipAddess = ipAddess;
	}

	public Long getTimeout() {
		return timeout;
	}

	public void setTimeout(Long timeout) {
		this.timeout = timeout;
	}

	public Boolean getTreatment() {
		return treatment;
	}

	public void setTreatment(Boolean treatment) {
		this.treatment = treatment;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}
}
